#pragma once
#include "MySprite.h"
#include "Collision.h"
#include "Timer.h"
#include "AudioManager.h"

#include <iostream>

class Mario : public MySprite
{
public:
	Mario();
	~Mario();

	void update(float dt);
	void handleInput(float dt);

	void setCollisionForPowerUp(sf::FloatRect small, sf::FloatRect big);	//Update the collision box to either small or big depending on Mario's power up state

	bool handleEnemyCollision(MySprite* enemy);	//Boolean returns false if Mario died from the collision, else it returns true and the enemy dies

	void addScore(int scoreToAdd);	//addScore to Mario
	void removeScore(int scoreToRemove);	//removeScore to Mario
	int getScore();	//Returns an integer of Mario's current score
	
	void addCoin();	//Adds a coin to Mario (it's very unlikely we'll ever add more than one coin every frame)
	void removeCoins();	//Removes all coins from Mario (again, unlikely we'll ever lose 1 or 2 coins, either all or nothing)
	int getCoins();	//Returns an integer of how many coins Mario has

	void addLife();	//Adds a life to Mario
	int getLives();	//Gets how many lives Mario has
	void setLives(int life);	//Sets how many lives Mario has

	void setWon(bool won);	//Set if Mario has won the level, to won
	bool getWon();	//Get if Mario has won the level

	bool isFlipped();	//Get if Mario's animation is currently flipped

	bool isPoweredUp();	//Get if Mario is currently powered up

	void bounce();	//Make Mario bounce, most commonly used after an enemy collision
	void kill();	//Kills Mario

	void powerUp();	//Powers Mario Up
	void powerDown();	//Powers Mario down

	void slideDownPole();	//Makes Mario play the sliding animation when he collides with the pole
	bool walkToCastle();	//Begins the walk from the flag to the castle, returning true when Mario reaches the castle

	bool canJump = true;	//Can Mario jump currently? (This prevents "infinite jumping" - jumping constantly every time Mario touches the ground by holding Up)
	bool inputsAllowed = true;	//Can we control Mario?

protected:
	enum PowerUp	//enum PowerUp stores the possible PowerUp states of Mario
	{
		Small = 0,
		Big = 1
	};

	enum Anims //Anims stores all the animations Mario can play (used for setting the correct anim based on his power up state)
	{
		Idle,
		Walk,
		Jump,
		Duck,
		Slide
	};

	//	//	//	//
	Animation idleBig;
	Animation walkBig;
	Animation jumpBig;
	Animation duckBig;
	Animation slideBig;
	Animation idleSmall;		//		All of Mario's animations, of all sizes
	Animation walkSmall;
	Animation jumpSmall;
	Animation duckSmall;
	Animation slideSmall;

	Animation dead;
	//	//	//	//	


	Animation* currentAnimation;	//Stores an Animation pointer to Mario's current animation

	PowerUp powerUpState;	//powerUpState of type PowerUp (enum) stores Mario's current power up state

	void setAnimForPowerUp(Anims anim);	//setAnimForPowerUp sets the correct size animation (big or small) for Mario's power up state

private:
	int score;	//Stores Mario's current score
	int coins;	//Stores how many coins Mario has
	int lives;	//Stores how many lives Mario has
	bool haveWon;	//Whether or not Mario has reached the pole and won the level
};

